<?php
/**
 * Module Name: WooCommerce Points and Rewards Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( class_exists( 'WC_Points_Rewards' ) ) :

 //*************** Actions ***************\\
 add_filter( 'wc_points_rewards_event_description', 'wpachievements_wcpar_description', 10, 3 );

 //*************** Functions that handles the point Descriptions ***************\\
 function wpachievements_wcpar_description( $event_description, $event_type, $event ) {
   switch ( $event_type ) {
     case 'wpachievements_achievement': $event_description = sprintf( __( '%s earned for getting the achievement: %s', 'wpachievements' ), $event->points, $event->data['achievement_id'] ); break;
     case 'wpachievements_achievement_added': $event_description = sprintf( __( '%s earned for admin adding the achievement: %s', 'wpachievements' ), $event->points, $event->data['achievement_id']  ); break;
     case 'wpachievements_achievement_removed': $event_description = sprintf( __( '%s removed by admin removing the achievement: %s', 'wpachievements' ), $event->points, $event->data['achievement_id']  ); break;
     case 'wpachievements_achievement_edited_add': $event_description = sprintf( __( '%s earned because an achievements points have been increased.', 'wpachievements' ), $event->points ); break;
     case 'wpachievements_achievement_edited_remove': $event_description = sprintf( __( '%s earned because an achievements points have been decreased.', 'wpachievements' ), $event->points ); break;


     case 'wpachievements_quest': $event_description = sprintf( __( '%s earned for getting the quest: %s', 'wpachievements' ), $event->points, $event->data['achievement_id'] ); break;
     case 'wpachievements_quest_added': $event_description = sprintf( __( '%s earned for admin adding the quest: %s', 'wpachievements' ), $event->points, $event->data['achievement_id']  ); break;
     case 'wpachievements_quest_removed': $event_description = sprintf( __( '%s removed by admin removing the quest: %s', 'wpachievements' ), $event->points, $event->data['achievement_id']  ); break;
     case 'wpachievements_quest_edited_add': $event_description = sprintf( __( '%s earned because an quest points have been increased.', 'wpachievements' ), $event->points ); break;
     case 'wpachievements_quest_edited_remove': $event_description = sprintf( __( '%s earned because an quest points have been decreased.', 'wpachievements' ), $event->points ); break;
     default: $event_description = apply_filters( 'wpachievements_trigger_description', $event_type ); break;
   }
   return $event_description;
 }

add_filter( 'wpachievements_get_sections_module', 'wpachievements_add_section_wcpr' );
function wpachievements_add_section_wcpr( $sections ) {
	$sections['wcpr'] = __( 'WooCommerce Points and Rewards', 'wpachievements' );
	return $sections;
}

/**
 * Check if sync is enabled
 *
 * @return boolean True is enabled
 */
function wpachievements_wcpr_is_sync_enabled() {
  if ( 'yes' == strtolower( wpachievements_get_site_option( 'wpachievements_wcpr_sync_enabled' ) ) ) {
    return true;
  }

  return false;
}

function wpachievements_wcpar_handle_points( $args = array() ) {

  $defaults = array(
      'activity'          => '',
      'user_id'           => NULL,
      'post_id'           => NULL,
      'points'            => 0,
      'current_user_rank' => '',
      'reference'         => '',
      'log_entry'         => '',
    );

  $args = wp_parse_args( $args, $defaults );

  if ( class_exists( 'WC_Points_Rewards_Manager' ) && wpachievements_wcpr_is_sync_enabled() ) {
    WC_Points_Rewards_Manager::increase_points( $args['user_id'], $args['points'], $args['activity'] );
  }
}
add_action( 'wpachievements_after_handle_points', 'wpachievements_wcpar_handle_points' );

function wpachievements_wcpar_decrease_points( $user_id, $points, $activity ) {
  if ( class_exists( 'WC_Points_Rewards_Manager' ) && wpachievements_wcpr_is_sync_enabled() ) {
    WC_Points_Rewards_Manager::decrease_points( $user_id, $points, $activity );
  }
}
add_action( 'wpachievements_after_decrease_points', 'wpachievements_wcpar_decrease_points', 10, 3 );

/**
 * Handle achievement points
 *
 * @param int $user_id
 * @param int $achievement_id
 * @return void
 */
function wpachievements_wcpar_handle_achievements( $user_id, $achievement_id ) {
  if ( ! wpachievements_wcpr_is_sync_enabled() ) {
    $woopoints = get_post_meta( $achievement_id, '_achievement_woo_points', true );

    if ( ! $woopoints ) {
      return;
    }

    WC_Points_Rewards_Manager::increase_points( $user_id, $woopoints, 'wpachievements_achievement', array( 'achievement_id' => $achievement_id ) );
  }
}
add_action( 'wpachievements_after_new_achievement', 'wpachievements_wcpar_handle_achievements', 10, 2 );
add_action( 'wpachievements_after_new_custom_achievement', 'wpachievements_wcpar_handle_achievements', 10, 2 );

/**
 * Handle quest points
 *
 * @param int $user_id
 * @param int $quest_id
 * @return void
 */
function wpachievements_wcpar_handle_quest( $user_id, $quest_id ) {
  if ( ! wpachievements_wcpr_is_sync_enabled() ) {
    $woopoints = get_post_meta( $quest_id, '_quest_woo_points', true );

    if ( ! $woopoints ) {
      return;
    }

    WC_Points_Rewards_Manager::increase_points( $user_id, $woopoints, 'wpachievements_quest', array( 'quest_id' => $quest_id ) );
  }
}
add_action( 'wpachievements_after_new_quest', 'wpachievements_wcpar_handle_quest', 10, 2 );

//*************** Admin Settings ***************\\
add_filter('wpachievements_achievements_modules_admin_settings', 'achievements_wcpr_admin', 10, 3);
function achievements_wcpr_admin($defaultsettings, $shortname, $current_section){
  if ( $current_section == 'wcpr' ) {
    $settings[] = array( 'title' => __( 'WooCommerce Points and Rewards', 'wpachievements' ), 'type' => 'title', 'desc' => '', 'id' => 'WooCommerce_options' );

    $settings[] = array(
            'title'   => __( 'Sync All Points', 'wpachievements' ),
            'desc'    => __( 'This will make all points gained be added to WooCommerce Points and Rewards.<br/><strong>Note:</strong> This is not recommeded as user can gain points quickly.', 'wpachievements' ),
            'id'      => $shortname.'_wcpr_sync_enabled',
            'type'    => 'checkbox',
            'default' => '',
          );

    $settings[] =  array( 'type' => 'sectionend', 'id' => 'WooCommerce_options');

    return $settings;
/**
  * If not, return the standard settings
  **/
	} else {
		return $defaultsettings;
	}
 }
endif;
?>